﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ens { namespace detail { namespace util {

/**
 * @brief   RFC3986 に従い、文字列をエスケープします。
 *
 * @param[out]  pOutLength  エスケープした文字列長
 * @param[out]  pOutBuffer  エスケープした文字列を格納するバッファ
 * @param[in]   bufferSize  pOutBuffer のサイズ
 * @param[in]   pString     文字列
 * @param[in]   length      文字列長
 *
 * @return  エスケープできたかどうか
 *
 * @pre
 *  - pOutLength != nullptr
 *  - pOutBuffer != nullptr
 *  - bufferSize > 0
 *  - pString != nullptr
 *  - pString が UTF-8 でエンコードされている
 *  - length > 0
 *
 * @details
 */
bool EscapeUriDataString(size_t* pOutLength, char* pOutBuffer, size_t bufferSize,
    const char* pString, size_t length) NN_NOEXCEPT;

/**
 * @brief   RFC3986 に従い、クエリストリングを検査します。
 *
 * @param[in]   pString クエリストリング
 * @param[in]   length  クエリストリング長
 *
 * @return  妥当なクエリストリングかどうか
 *
 * @pre
 *  - pString != nullptr
 *  - length > 0
 *
 * @details
 */
bool VerifyUriQueryString(const char* pString, size_t length) NN_NOEXCEPT;

}}}}
