﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/ens_Types.h>
#include <nn/settings/settings_Language.h>
#include <nn/time/time_Types.h>

namespace nn { namespace ens { namespace detail {

/**
 * @brief   通報カテゴリ
 *
 * @details
 *  TODO: 通報 API を提供する時に ens_Types.h に移動させる。
 */
enum ReportCategory
{
    ReportCategory_Personal                      = 0,   //!< 個人情報、出会い
    ReportCategory_Criminal                      = 1,   //!< 暴力的な内容
    ReportCategory_Immoral                       = 2,   //!< 公序良俗に反する内容
    ReportCategory_Harassment                    = 3,   //!< 他人への嫌がらせ、悪口
    ReportCategory_Commercial                    = 4,   //!< 営利宣伝目的
    ReportCategory_SexuallyExplicit              = 5,   //!< わいせつな内容
    ReportCategory_Other                         = 6,   //!< その他不適切な内容

/*
    // ユーザー通報
    ReportCategory_PlayingInactivity             = 100, //!< 放置
    ReportCategory_PlayingFrequentDisconnection  = 101, //!< 頻繁な通信切断
    ReportCategory_PlayingUnsportsmanlikeConduct = 102, //!< 自滅をくりかえす／味方チームへの妨害
    ReportCategory_PlayingNetworkManipulation    = 103, //!< 故意に通信品質を下げている
    ReportCategory_Cheating                      = 104, //!< 改造やチート
    ReportCategory_InappropriateNickname         = 105, //!< 不適切なニックネーム
*/
};

/**
 * @brief   通報するコンテンツの情報
 *
 * @details
 */
struct ReportContentInfo
{
    uint64_t id;                         //!< コンテンツの ID
    Digest digest;                       //!< コンテンツのダイジェスト
    nn::settings::LanguageCode language; //!< コンテンツの言語
    nn::time::PosixTime createdAt;       //!< コンテンツの作成時刻
};

/**
 * @brief   認証トークン
 *
 * @details
 *  認証トークン文字列は NULL 終端されます。
 */
struct AuthToken
{
    char value[128];
};

}}}
