﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <algorithm>
#include <atomic>
#include <new>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_TimeSpan.h>

#include <nn/ens/ens_ResultPublic.h>
#include <nn/ens/ens_ResultPrivate.h>
#include <nn/ens/ens_Types.h>
#include <nn/ens/detail/ens_DynamicCast.h>
#include <nn/ens/detail/ens_LibrarySettings.h>
#include <nn/ens/detail/ens_Log.h>
#include <nn/ens/detail/ens_Macros.h>
#include <nn/ens/detail/ens_TypesCommon.h>
#include <nn/ens/detail/ens_TypesDetail.h>

#include <nn/ens/detail/core/ens_Allocator.h>
#include <nn/ens/detail/core/ens_Url.h>
#include <nn/ens/detail/util/ens_HttpErrorHandler.h>
#include <nn/ens/detail/util/ens_HttpUtility.h>

#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>

#include <nn/account/account_Types.h>

#include <nn/time/time_Types.h>

#include <nn/result/result_HandlingUtility.h>

#include <nn/util/util_BitFlagSet.h>
#include <nn/util/util_Endian.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_IntUtil.h>
#include <nn/util/util_LockGuard.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_Utf8StringUtil.h>
