﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_AuthenticationTask.h>
#include <nn/ens/detail/util/ens_MessagePackReader.h>
#include <nn/ens/ens_TypesForAcbaa.h>

namespace nn { namespace ens { namespace detail { namespace app_acbaa { namespace task {

/**
 * @brief   GetMyDesignHeaderList の非同期処理実装タスク
 *
 * @details
 */
class TaskGetMyDesignHeaderList : public detail::core::AuthenticationTask
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskGetMyDesignHeaderList() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~TaskGetMyDesignHeaderList() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。（作者指定）
     *
     * @param[out]  pOutCount       pOutHeaderList に格納した要素数
     * @param[out]  pOutTotalCount  サーバーで保持している投稿したマイデザインの総数
     * @param[out]  pOutHeaderList  ヘッダリストを格納するバッファ
     * @param[in]   count           pOutHeaderList の要素数
     * @param[in]   offset          取得オフセット
     * @param[in]   authorId        作者 ID
     *
     * @details
     */
    void SetParameter(int* pOutCount, int* pOutTotalCount, MyDesignHeader pOutHeaderList[],
        int count, int offset, const MyDesignAuthorId& authorId) NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。（検索クエリ指定）
     *
     * @param[out]  pOutCount       pOutHeaderList に格納した要素数
     * @param[out]  pOutTotalCount  検索条件にマッチしたマイデザインの総数
     * @param[out]  pOutHeaderList  ヘッダリストを格納するバッファ
     * @param[in]   count           pOutHeaderList の要素数
     * @param[in]   offset          取得オフセット
     * @param[in]   pSearchQuery    検索クエリ
     *
     * @details
     */
    void SetParameter(int* pOutCount, int* pOutTotalCount, MyDesignHeader pOutHeaderList[],
        int count, int offset, const char* pSearchQuery) NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。（全体）
     *
     * @param[out]  pOutCount       pOutHeaderList に格納した要素数
     * @param[out]  pOutTotalCount  サーバーで保持している投稿されたマイデザインの総数
     * @param[out]  pOutHeaderList  pOutHeaderList の要素数
     * @param[in]   count           ヘッダリスト要素数
     * @param[in]   offset          取得オフセット
     *
     * @details
     */
    void SetParameter(int* pOutCount, int* pOutTotalCount, MyDesignHeader pOutHeaderList[],
        int count, int offset) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result ExecuteSteps() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    struct ListParseBits
    {
        Bit64 total : 1;
        Bit64 count : 1;
    };

    //
    struct HeaderParseBits
    {
        Bit64 myDesignId : 1;
        Bit64 authorName : 1;
        Bit64 updatedAt : 1;
        Bit64 digest : 1;
        Bit64 metadata : 1;
    };

private:
    //
    int* m_pOutCount;
    int* m_pOutTotalCount;
    MyDesignHeader* m_pOutHeaderList;
    int m_Offset;
    int m_ListCount;
    //
    MyDesignAuthorId m_AuthorId;
    const char* m_pSearchQuery;
    //
    int m_SetIndex;
    //
    ListParseBits m_ListParseBits;
    HeaderParseBits m_HeaderParseBits;
    //
    bool m_IsHeaderListParsing;

private:
    //
    nn::Result StepGet() NN_NOEXCEPT;
    //
    bool ResponseReadCallbackImpl(const nn::ens::detail::util::JsonPath& jsonPath,
        const detail::util::DataHolder& holder) NN_NOEXCEPT;

private:
    //
    static bool ResponseReadCallback(const nn::ens::detail::util::JsonPath& jsonPath,
        const detail::util::DataHolder& holder, void* pParam) NN_NOEXCEPT;
};

}}}}}
