﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_AuthenticationTask.h>
#include <nn/ens/ens_TypesForAcbaa.h>
#include <nn/npns/npns_Types.h>

namespace nn { namespace ens { namespace detail { namespace app_acbaa { namespace task {

/**
 * @brief   ActivateNotificationService の非同期処理実装タスク
 *
 * @details
 */
class TaskActivateNotificationService : public detail::core::AuthenticationTask
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskActivateNotificationService() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~TaskActivateNotificationService() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[in]   user    ユーザーアカウント
     *
     * @details
     */
    void SetParameter(const nn::account::Uid& user) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result ExecuteSteps() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::account::Uid m_User;
    nn::npns::NotificationToken m_NotificationToken;

private:
    //
    nn::Result StepGetToken() NN_NOEXCEPT;
    nn::Result StepUploadToken() NN_NOEXCEPT;
};

}}}}}
