﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @namespace   nn::ens
 *
 * @brief       拡張ネットワークサービス (Extended Network Service) の名前空間です。
 *
 * @details
 *  各 API はスレッドセーフです。
 *
 *  ### @anchor about_ens_pre_condition ネットワーク通信を行う API の事前条件について
 *  nn::ens の通信機能の利用には以下の項目をすべて満たしている必要があります。@n
 *  - nn::nifm によるネットワーク利用要求が受理済
 *  - nn::ens::StartServiceLoop() を呼び出し済
 *
 *  ### @anchor about_ens_async_api 非同期処理 API の利用について
 *  - 非同期処理は nn::ens::StartServiceLoop() の内部で処理実行されます。
 *    nn::ens::StartServiceLoop() 実行スレッドへの CPU 割り当てが非同期処理の進み具合に影響します。
 *  - 非同期処理の完了まで、非同期処理 API への引数(参照渡しやポインタ渡し)は操作、破棄をしてはいけません。
 *  - 非同期処理を複数同時に呼び出した場合でも、逐次処理されます。
 *
 */

#include <nn/ens/ens_Api.h>
