﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "capsrv_CachedMovieStream.h"
#include "../capsrv_AlbumMovieReadStreamHandle.h"

namespace nn{ namespace capsrv{ namespace movie{

    struct AlbumMovieReadStreamDataSectionAccessor
    {
    public:
        static nn::Result Read(size_t* pOutReadSize, void* buffer, size_t size, int64_t offset, void* userData) NN_NOEXCEPT;
        static nn::Result Write(int64_t offset, const void* buffer, size_t size, void* userData) NN_NOEXCEPT;
        static nn::Result Shrink(int64_t size, void* userData) NN_NOEXCEPT;

        MovieStreamAccessor GetAccessor() NN_NOEXCEPT;

    public:
        AlbumMovieReadStreamHandle handle;
    };

}}}
