﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{ namespace capsrv{

    //! @brief 画面写真の大きさを表す値です。
    enum ScreenShotSize
    {
        //! @brief 幅 1280 ピクセル 高さ 720 ピクセル
        ScreenShotSize_1280x720 = 0,

        //! @brief 幅 1920 ピクセル 高さ 1080 ピクセル
        ScreenShotSize_1920x1080 = 1,

        //! @brief 既定の画面写真サイズ
        ScreenShotSize_Default = ScreenShotSize_1280x720,
    };

    typedef uint32_t ScreenShotSizeType;

}}
