﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{ namespace capsrv{

    //! @brief 画面写真の回転を表す値です。
    //! @details
    //!   デバイスを通常の向きで見た場合に画面写真がどれだけ回転しているかを表します。
    enum ScreenShotOrientation
    {
        //! @brief 無回転です。
        //! @details 撮影時にディスプレイの上下とカメラの上下が一致していたことを表します。
        ScreenShotOrientation_Default = 0,

        //! @brief 90 度回転です。
        //! @details 撮影時にディスプレイの右側がカメラの上方向に一致していたことを表します。
        ScreenShotOrientation_Rotate90 = 1,

        //! @brief 180 度回転です。
        //! @details 撮影時にディスプレイの下側がカメラの上方向に一致していたことを表します。
        ScreenShotOrientation_Rotate180 = 2,

        //! @brief 270 度回転です。
        //! @details 撮影時にディスプレイの左側がカメラの上方向に一致していたことを表します。
        ScreenShotOrientation_Rotate270 = 3,
    };

    typedef uint32_t ScreenShotOrientationType;

}}
