﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/capsrv/capsrv_AlbumFileContents.h>

namespace nn{ namespace capsrv{

    //! @brief ファイルの種類ごとのファイルサイズの上限値です。
    enum AlbumFileSizeLimit : int64_t
    {
        //! @brief 画面写真ファイルの最大サイズ（バイト）です。
        AlbumFileSizeLimit_ScreenShot = 500 * 1024ll,

        //! @brief 動画ファイルの最大サイズ（バイト）です。
        AlbumFileSizeLimit_Movie = 0x80000000ll,
    };

    //! @brief 動画のデータ部分の最大サイズ（バイト）です。
    static const int64_t AlbumMovieDataSizeMax  = 0x80000000llu;

    //! @brief 動画のデータ部分の読み書きの単位サイズ（バイト）です。
    //! @details
    //! 動画のデータの読み書きを行う際にはオフセットとサイズはともにこの値の整数倍を指定しなければなりません。
    //! 任意のオフセット・サイズでの読み込みを行う場合には nn::capsrv::MovieReaderFileSystem を利用して nn::fs の API 経由でアクセスします。
    static const int64_t AlbumMovieDataUnitSize = 256 * 1024;

    inline int64_t GetAlbumFileSizeLimitImpl(AlbumFileContentsType contents) NN_NOEXCEPT
    {
        switch (contents)
        {
            case AlbumFileContents_ScreenShot:
            {
                return AlbumFileSizeLimit_ScreenShot;
            }
            case AlbumFileContents_Movie:
            {
                return AlbumFileSizeLimit_Movie;
            }
            case AlbumFileContents_ExtraScreenShot:
            {
                return AlbumFileSizeLimit_ScreenShot;
            }
            case AlbumFileContents_ExtraMovie:
            {
                return AlbumFileSizeLimit_Movie;
            }
            default:
            {
                return 0;
            }
        }
    }

}}
