﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/album/album_AlbumFileEntry.private.h>
#include <nn/album/album_AlbumFileAccessForDebug.h>

namespace nn { namespace album {

//! @name アルバム関連ファイルを操作するデバッグ専用機能（製品機では使用不可）
//! @{

//----------------------------------------------------------------------------
//! @brief アルバム静止画・動画ファイルを削除します。
//!
//! @param[in] entry    削除する対象ファイルの識別子です。
//!
//! @pre nn::album::Initialize() によりアルバムライブラリが初期化済みである
//!
//! @return nn::Result 型で結果を返します。
//!
//! @details
//! entry で指定されたアルバムファイルを削除します。
//! 本 API は開発時専用のデバッグ機能であり、製品機環境では使用できません。
//!
//! 返値が nn::Result::IsSuccess() == true でない場合は、
//! その値を使ってエラービューアを起動することでエラー内容を出画できます。
//!
Result DeleteAlbumFileForDebug(const AlbumFileEntry& entry) NN_NOEXCEPT;


//! @}

}}  // namespace nn::album
