﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdio>
#include <cstring>
#include <cstdarg>

//  Work around MS tools not supporting snprintf
#ifdef WIN32
#define nn_snprintf _snprintf
#else
#define nn_snprintf snprintf
#endif

class AppConstants
{
public:
    static const char           *g_NintendoSdkEnvVarName;
    static const char           *g_DataIdHeaderName;
    static const char           *g_SslIncludeSubdir;
    static const char           *g_SslSrcBuiltin;
    static const char           *g_pErrInvalidArgs;
    static const char           *g_DataEnumName;
    static const int            g_MaxPathLen = 1024;
};


#ifdef NN_BUILD_CONFIG_OS_WIN
#define FILE_PATH_DELIM         "\\"
#else
#define FILE_PATH_DELIM         "/"
#endif


enum LogLevel
{
    LogLevel_Debug    = 3,
    LogLevel_Info     = 2,
    LogLevel_Warning  = 1,
    LogLevel_Error    = 0
};


#ifdef NN_DETAIL_SSL_ENABLE_DEBUG
static int g_LogLevel = LogLevel_Debug;
#else
static int g_LogLevel = LogLevel_Warning;
#endif

static const char *g_LogLevelPrefix[] =
{
    "[ERR] ",
    "[WRN] ",
    "[INF] ",
    "[DBG] ",
};

#define LOG(level, fmt, ...)                                             \
    {                                                                    \
        if (level <= g_LogLevel) {                                       \
            Log::LogOutput(g_LogLevelPrefix[level], fmt, ##__VA_ARGS__); \
        }                                                                \
    }

#define LOGE(fmt, ...)          LOG(LogLevel_Error, fmt, ##__VA_ARGS__)
#define LOGW(fmt, ...)          LOG(LogLevel_Warning, fmt, ##__VA_ARGS__)
#define LOGI(fmt, ...)          LOG(LogLevel_Info, fmt, ##__VA_ARGS__)
#define LOGD(fmt, ...)          LOG(LogLevel_Debug, fmt, ##__VA_ARGS__)

class Log
{
public:
    static void LogOutput(const char *pPrefix, const char *pFmt, ...)
    {
        char                        *pBuf;
        size_t                      bufSize;
        va_list                     args;

        bufSize = strlen(pPrefix) + strlen(pFmt) + 1;
        pBuf = new char[bufSize];
        if (pBuf != nullptr)
        {
            memset(pBuf, 0, bufSize);
            strcpy(pBuf, pPrefix);
            strcat(pBuf, pFmt);
            va_start(args, pFmt);
            vprintf(pBuf, args);
            va_end(args);
            delete[] pBuf;
            pBuf = NULL;
        }
    };
};
