﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SettingsManager
{
    using System;

    /// <summary>
    /// 内部エラーが発生した場合にスローされる例外。このクラスは継承できません。
    /// </summary>
    internal sealed class SettingsManagerException : Exception
    {
        /// <summary>
        /// 指定したエラーメッセージを利用して、SettingsManagerException クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外の原因を説明するエラーメッセージです。</param>
        public SettingsManagerException(string message)
            : base(message)
        {
        }

        /// <summary>
        /// 指定したエラーメッセージと、例外の原因である内部例外への参照を利用して、SettingsManagerException クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外の原因を説明するエラーメッセージです。</param>
        /// <param name="exception">例外の原因である内部例外への参照です。</param>
        public SettingsManagerException(string message, Exception exception)
            : base(message, exception)
        {
        }
    }
}
