﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SettingsManager
{
    using System.ComponentModel.Composition;
    using Nintendo.ToolFoundation.CommandLine;

    /// <summary>
    /// コマンドのインターフェイスです。
    /// </summary>
    [InheritedExport]
    internal interface ICommand
    {
        /// <summary>
        /// コマンドが選択されたか否かを表す値を返します。
        /// </summary>
        bool IsSelected { get; }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="parser">コマンドラインパーサです。</param>
        void RegiserWith(DelegateBasedCommandLineParser parser);

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        void Execute();
    }
}
