﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Windows.h>

#include <winusb.h>
NN_PRAGMA_PUSH_WARNINGS
#pragma warning(disable: 4668)
#include <setupapi.h>
NN_PRAGMA_POP_WARNINGS

struct UsbDeviceInfo
{
    HANDLE                  deviceHandle;
    WINUSB_INTERFACE_HANDLE winUsbHandle;
    USHORT                  interfaceIndex;
    unsigned char           pipeBulkIn;
    unsigned char           pipeBulkOut;
};

struct DsHeader
{
    uint32_t    begin;
    uint32_t    bytes;
    uint32_t    end;
};
