﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Text.RegularExpressions;

namespace MakeParentalControlMasterKey
{
    class MasterKey
    {
        // the encryption key list
        public static readonly byte[][] EncryptionKeys = {
            // index 0
            new byte[] { 0x30,0x7A,0x24,0x6C,0xB9,0x6C,0xF2,0xEC,0x1E,0x08,0xAF,0x05,0x06,0x56,0xA2,0x5E,0x29,0x2C,0x76,0xD2,0x89,0xA7,0xB0,0xD9,0x59,0x68,0xB7,0x76,0x1A,0x14,0x74,0xCC },
            // index 1
            new byte[] { 0x56,0x34,0xA7,0x96,0xF7,0xB5,0x8B,0x04,0x13,0x4E,0x1F,0xD6,0x27,0x68,0xA1,0xFA,0xC1,0xAA,0xF8,0x79,0xF6,0xEF,0xC4,0x93,0x8C,0x66,0xFE,0xEB,0xB6,0xD1,0x14,0xA6 }
            // (more keys come here when updated)
        };

        // Makes a master key from inquiryCode with EncryptionKeys
        public static string Make(string inquiryCode)
        {
            // xxxxx-yyyyy --> xxxxxyyyyy
            inquiryCode = Regex.Replace(inquiryCode, "^([0-9]{5})-([0-9]{5})$", "$1$2");

            if (!Regex.IsMatch(inquiryCode, "^[0-9]{10}$"))
            {
                throw new ArgumentException("inquiry-code must be 10 digits");
            }
            for (var index = 0; index < EncryptionKeys.Length; ++index)
            {
                var key = EncryptionKeys[index];
                string codeHeadString = (10 + index).ToString("D2");
                // first 2-chars of inquiryCode is equal to (10 + key-index)
                if (inquiryCode.StartsWith(codeHeadString))
                {
                    byte[] codeBytes = Encoding.UTF8.GetBytes(inquiryCode);
                    // (same as using nn::crypto::GenerateHmacSha256Mac)
                    var hmac = new System.Security.Cryptography.HMACSHA256(key);
                    byte[] resultBytes = hmac.ComputeHash(codeBytes);
                    // pick up first 6 bytes and make numeric value (in little-endian)
                    var resultValue =
                        ((ulong)resultBytes[0] << 0) |
                        ((ulong)resultBytes[1] << 8) |
                        ((ulong)resultBytes[2] << 16) |
                        ((ulong)resultBytes[3] << 24) |
                        ((ulong)resultBytes[4] << 32) |
                        ((ulong)resultBytes[5] << 40);
                    // use lower 8 digits as a master key
                    resultValue %= 100000000;
                    return resultValue.ToString("D8");
                }
            }
            throw new ArgumentException("Invalid or unsupported inquiry-code value");
        }
    }
}
