﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.Reflection;
using System.IO;
using Nintendo.Foundation.IO;
using MakeInitialImage;

namespace ReadInitialImage
{
    public abstract class CommandCommon
    {
        [CommandLineOption('v', "verbose",
        Description = "Output trace logs.")]
        public bool Verbose { get; set; }

        [CommandLineOption('i', "input",
            Description = "input initial image file")]
        public string InputFile { get; set; }

        public abstract void Run();

        public void RunCommand(Action<InitialImageReader> action)
        {
            using (var readStream = new FileInfo(InputFile).OpenRead())
            {
                var reader = new InitialImageReader(readStream);

                action(reader);
            }
        }

        public static CommandCommon FindActivatedSubCommand(object commandContainer)
        {
            var containerType = commandContainer.GetType();
            foreach (var property in containerType.GetProperties())
            {
                if (0 < property.GetCustomAttributes<CommandLineSubCommandAttribute>(true).Count())
                {
                    var subCommandValue = property.GetValue(commandContainer);
                    if (subCommandValue is CommandCommon && subCommandValue != null)
                    {
                        return (CommandCommon)subCommandValue;
                    }
                }
            }

            throw new Exception("Found no subcommands");
        }
    }
}
