﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using CommandUtility;
using Nintendo.Foundation.IO;

namespace MakeSignedBinary.Commands
{
    public class VerifyCommand : SubCommandCommon
    {
        [CommandLineOption('i', "input", Description = "input file")]
        public string InputFile { get; set; }

        [CommandLineOption('a', "append", Description = "append file", DefaultValue = new string[] { })]
        public string[] AppendFiles { get; set; }

        [CommandLineOption('k', "key", Description = "input key file", IsRequired = true)]
        public string KeyConfigFile { get; set; }

        public override int Run()
        {
            var keyConfig = KeyConfig.Load(KeyConfigFile);

            if (Utility.VerifySignBinary(keyConfig, InputFile, AppendFiles))
            {
                Console.WriteLine("Succeeded to verify.");
                return 0;
            }
            else
            {
                Console.Error.WriteLine($"Failed to verify. file={InputFile}");
                return 1;
            }
        }
    }
}
