﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using CommandUtility;
using Nintendo.Foundation.IO;
using System.IO;

namespace MakeSignedBinary.Commands
{
    public class ChangeKeyCommand : SubCommandCommon
    {
        [CommandLineOption('i', "input", Description = "input file")]
        public string InputFile { get; set; }

        [CommandLineOption('o', "output", Description = "output file", IsRequired = true)]
        public string OutputFile { get; set; }

        [CommandLineOption('a', "append", Description = "append file", DefaultValue = new string[] { })]
        public string[] AppendFiles { get; set; }

        [CommandLineOption("old-key", Description = "input old key file", IsRequired = true)]
        public string OldKeyConfigFile { get; set; }

        [CommandLineOption("new-key", Description = "input new key file", IsRequired = true)]
        public string NewKeyConfigFile { get; set; }

        public override int Run()
        {
            var oldKeyConfig = KeyConfig.Load(OldKeyConfigFile);
            var newKeyConfig = KeyConfig.Load(NewKeyConfigFile);

            using (var tempHolder = new TemporaryFileHolder("MakeSignedBinary"))
            {
                var decryptedFile = tempHolder.CreateTemporaryFilePath("decrypted");

                Utility.RemoveSignBinary(oldKeyConfig, decryptedFile.FullName, InputFile);

                Utility.SignBinary(OutputFile, decryptedFile.FullName, AppendFiles, newKeyConfig, tempHolder);
            }

            return 0;
        }
    }
}
