﻿using System;
using CommandUtility;
using Nintendo.Foundation.IO;
using System.IO;

namespace MakeRecoveryWriter.Commands
{
    public class ExtractCommand : SubCommandCommon
    {
        [CommandLineOption('i', "input", Description = "input recovery writer image file", IsRequired = true)]
        public string InputFile { get; set; }

        [CommandLineOption("program", Description = "output recovery writer program image")]
        public string OutputProgram { get; set; }

        [CommandLineOption("parameter", Description = "output parameter image")]
        public string OutputParameter { get; set; }

        [CommandLineOption("gpt", Description = "output gpt image")]
        public string OutputGpt { get; set; }

        [CommandLineOption("bootconfig", Description = "output boot config image")]
        public string OutputBootConfig { get; set; }

        [CommandLineOption("bootloader", Description = "output boot loader image")]
        public string OutputBootLoader { get; set; }

        [CommandLineOption("package2", Description = "output package2")]
        public string OutputPackage2 { get; set; }

        [CommandLineOption("system-partition", Description = "output system partition")]
        public string OutputSystemPartition { get; set; }

        public void ProcessOutputArgument(Stream reader, string outputArgument, long offset, long size)
        {
            if(outputArgument != null)
            {
                var fileInfo = new FileInfo(outputArgument);
                using (var writer = fileInfo.OpenWrite())
                {
                    FileUtility.WriteBytes(
                        writer,
                        FileUtility.ReadRange(reader, offset, size));
                }
            }
        }

        public override int Run()
        {
            var fileInfo = new FileInfo(InputFile);

            using (var reader = fileInfo.OpenRead())
            {
                var parameter = RecoveryWriterImage.LoadParameter(reader);

                ProcessOutputArgument(reader, OutputProgram, RecoveryWriterImage.ProgramOffset, RecoveryWriterImage.ProgramSize);
                ProcessOutputArgument(reader, OutputParameter, RecoveryWriterImage.ParameterOffset, RecoveryWriterImage.ParameterSize);
                ProcessOutputArgument(reader, OutputGpt, RecoveryWriterImage.GptOffset, RecoveryWriterImage.GptSize);
                ProcessOutputArgument(reader, OutputBootConfig, parameter.BctOffsetOnQspi, parameter.BctSize);
                ProcessOutputArgument(reader, OutputBootLoader, parameter.BootLoaderOffsetOnQspi, parameter.BootLoaderSize);
                ProcessOutputArgument(reader, OutputPackage2, parameter.Package2OffsetOnQspi, parameter.Package2Size);
                ProcessOutputArgument(reader, OutputSystemPartition, parameter.SystemPartitionOffsetOnQspi, parameter.SystemPartitionSize);
            }

            return 0;
        }
    }
}
