﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using Nintendo.Foundation.IO;
using System.Text.RegularExpressions;

namespace MakePackage1
{
    public class MakePackage1Argument
    {
        [CommandLineOption("bct",
            Description = "set input bct file.",
            IsRequired = true)]
        public string BctFile { get; set; }

        [CommandLineOption("bootloader",
            Description = "set input bootloader file.",
            IsRequired = true)]
        public string BootLoaderFile { get; set; }

        [CommandLineOption('o', "output",
            Description = "set output package1 path.",
            IsRequired = true)]
        public string OutputFile { get; set; }
    }

    class Program
    {
        static void Main(string[] args)
        {
#if !DEBUG
            try
            {
#endif
            MakePackage1Argument parameters = new MakePackage1Argument();
            if (CommandLineParser.Default.ParseArgs<MakePackage1Argument>(args, out parameters))
            {
                var bctFileInfo = MakeExistedFileInfo("Bct File", parameters.BctFile);
                var blFileInfo = MakeExistedFileInfo("BootLoader File", parameters.BootLoaderFile);
                var outputFileInfo = new FileInfo(parameters.OutputFile);
                Program.MakePackage1(outputFileInfo, bctFileInfo, blFileInfo);
            }
            else
            {
                return;
            }
#if !DEBUG
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine("エラー: {0}", exception.Message);
                Console.Error.WriteLine("{0}", exception.StackTrace);
                Environment.Exit(1);
            }
#endif
        }

        private static FileInfo MakeExistedFileInfo(string argumentName, string fileName)
        {
            var fileInfo = new FileInfo(fileName);
            if (!fileInfo.Exists)
            {
                throw new Exception(string.Format("{0}({1}) is not found.", argumentName, fileInfo.FullName));
            }

            return fileInfo;
        }

        private static void MakePackage1(FileInfo outputFileInfo, FileInfo bctFileInfo, FileInfo blFileInfo)
        {
            using (var output = outputFileInfo.OpenWrite())
            {
                if(0x100000 < bctFileInfo.Length)
                {
                    throw new Exception(string.Format("Bct is Too Large. filename = {0}", bctFileInfo.FullName));
                }

                using (var bctFile = bctFileInfo.OpenRead())
                {
                    bctFile.CopyTo(output);
                }

                var paddingSize1 = 0x100000 - bctFileInfo.Length;
                var padding1 = new byte[paddingSize1];
                output.Write(padding1, 0, (int)paddingSize1);

                if (0x40000 < blFileInfo.Length)
                {
                    throw new Exception(string.Format("BootLoader is Too Large. filename = {0}", blFileInfo.FullName));
                }

                using (var blFile = blFileInfo.OpenRead())
                {
                    blFile.CopyTo(output);
                }

                var paddingSize2 = 0x40000 - blFileInfo.Length;
                var padding2 = new byte[paddingSize2];
                output.Write(padding2, 0, (int)paddingSize2);
            }
        }
    }
}
