﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

namespace MakeInitialImage
{
    public class InitialImageReader
    {
        public InitialImageReader(Stream inputStream)
        {
            this.InputStream = inputStream;
            ReadHeader();
            ReadCommands();
        }

        private void ReadCommands()
        {
            var partition = InitialImageInfo.Partitions[0];
            InputStream.Seek(partition.Address, SeekOrigin.Begin);
            int numCommands = Utility.ReadBinary<int>(InputStream);
            var ret = new List<InitialImageCommand>();
            for (int i = 0; i < numCommands; i++)
            {
                ret.Add(Utility.ReadBinary<InitialImageCommand>(InputStream));
            }

            Commands = ret;
        }

        private void ReadHeader()
        {
            InputStream.Seek(0, SeekOrigin.Begin);
            InitialImageInfo = Utility.ReadBinary<InitialImageInfo>(InputStream);
        }

        public List<InitialImageCommand> Commands { get; set; }
        public InitialImageInfo InitialImageInfo { get; set; }
        private Stream InputStream { get; set; }
    }
}
