﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.InteropServices;

namespace MakeInitialImage
{
    public class StaticInitialImageInfo
    {
        public static int FormatVersion = 2;
    }

    [Serializable()]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct InitialImageInfo
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = SizeOfSignature)]
        public string Signature;

        public int Version;

        public int NumPartions;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = SizeOfReserved)]
        public byte[] Reserved;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = MaxPartitions)]
        public InitialImagePartitionInfo[] Partitions;

        public static InitialImageInfo MakeNew()
        {
            return new InitialImageInfo()
            {
                Signature = "INITIMG",
                Version = StaticInitialImageInfo.FormatVersion,
                NumPartions = 0,
                Reserved = new byte[SizeOfReserved],
                Partitions = new InitialImagePartitionInfo[MaxPartitions]
            };
        }

        public const int SizeOfSignature = 8;
        public const int SizeOfReserved = 48;
        public const int MaxPartitions = 64;
    }

    [Serializable()]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct InitialImagePartitionInfo
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 72)]
        public string Name;
        public long Address;
        public long Size;
    }
}
