﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;
using CommandUtility;

namespace MakeGptPartition
{
    public class MakeGptPartitionArguments
    {
        [CommandLineSubCommand("make", Description = "make gpt.")]
        public Commands.MakePartitionCommand MakePartitionCommand { get; set; }

        [CommandLineSubCommand("info", Description = "print infos of gpt.")]
        public Commands.GetInfoCommand GetInfoCommand { get; set; }
    }

    public class Program
    {
        public static void Main(string[] args)
        {
#if !DEBUG
            try
            {
#endif
            System.Environment.Exit(
                MultiCommandRunner<MakeGptPartitionArguments>.Run(args));
#if !DEBUG
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine("[ERROR] {0}", exception.Message);
                Console.Error.WriteLine("{0}", exception.StackTrace);
                Environment.Exit(1);
            }
#endif
        }
    }
}
