﻿using System;
using System.IO;
using System.Linq;
using System.Windows.Forms;

namespace Nintendo.Log
{
    internal class Program
    {
        private static void Run(string[] args)
        {
            Application.EnableVisualStyles();
            Application.DoEvents();

            LogViewerWindow window;
            try
            {
                LogViewerWindow.LoadLayout();
                window = LogViewerWindow.GetMainWindow();
            }
            catch (FileNotFoundException)
            {
                window = new LogViewerWindow(new LogViewerClientTab());
            }

            foreach (var logFilePath in args.Where(arg => LogViewerWindow.IsLogFilePath(arg)))
            {
                window.OpenLogFile(logFilePath);
            }

            Application.Run(window);
        }

        [STAThread]
        private static void Main(string[] args)
        {
            try
            {
                Run(args);
            }
            catch (Exception exception)
            {
                MessageBox.Show(
                    "Nintendo Log Viewer is terminated abnormally." + Environment.NewLine + Environment.NewLine + exception.ToString());
            }
        }
    }
}
