﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Security;
using System.Text;
using System.Text.RegularExpressions;
using System.Web.Script.Serialization;
using System.Xml;
using System.Xml.Linq;

namespace Nintendo.Log
{
    static class LogConverter
    {
        private static string PrettyJson(string text)
        {
            return
                text.Replace(
                    "{", "{" + Environment.NewLine + "  ").Replace(
                    ",", "," + Environment.NewLine + "  ").Replace(
                    "}", Environment.NewLine + "}");
        }

        public static string ToJsonText(Dictionary<string, object> log, bool isPretty = false)
        {
            var serializer = new JavaScriptSerializer();
            var logForJson = new Dictionary<string, object>();
            foreach (var pair in log)
            {
                logForJson[pair.Key] =
                    (pair.Key == "Timestamp")
                        ? ((DateTime)log["Timestamp"]).ToString()
                        : logForJson[pair.Key] = pair.Value;
            }
            var jsonText = serializer.Serialize(logForJson);

            return isPretty
                ? PrettyJson(jsonText)
                : jsonText;
        }

        private static readonly Regex SgrCommandPattern = new Regex(@"\u001b\[(\d+(;\d+)*)?m", RegexOptions.Compiled);

        private static string StripSgrCommand(string text)
        {
            return SgrCommandPattern.Replace(text, string.Empty);
        }

        private static string EscapeNewLineCharacter(string text)
        {
            return text.Replace("\r\n", "&#x0D;&#x0A;").Replace("\r", "&#x0D;").Replace("\n", "&#x0A;");
        }

        public static string ToXmlText(Dictionary<string, object> log, bool isPretty = false)
        {
            var root = new XElement("Log");

            foreach (var pair in log)
            {
                root.Add(
                    new XElement(
                        pair.Key,
                        EscapeNewLineCharacter(WebUtility.HtmlEncode(StripSgrCommand(pair.Value.ToString())))));
            }

            return isPretty
                ? root.ToString()
                : root.ToString(SaveOptions.DisableFormatting);
        }
    }
}
