﻿using System;
using System.Net;
using System.Net.Sockets;
using System.Threading.Tasks;

namespace Nintendo.Htcs
{
    public class HtcsListener
    {
        public HtcsListener(string portName) :
            this (new HtcsEndPoint(HtcsPeerName.Any, portName))
        {
        }

        public HtcsListener(HtcsEndPoint endPoint) :
            this (endPoint, 0)
        {
        }

        public HtcsListener(HtcsEndPoint endPoint, int portNumber)
        {
            LocalEndPoint = endPoint;
            TcpListener = new TcpListener(IPAddress.Loopback, portNumber);
        }

        public TcpClient AcceptTcpClient()
        {
            return TcpListener.AcceptTcpClient();
        }

        public Task<TcpClient> AcceptTcpClientAsync()
        {
            return TcpListener.AcceptTcpClientAsync();
        }

        private void RegisterPortMap()
        {
            // ポートマップの登録
            var ipEndPoint = (IPEndPoint)TcpListener.LocalEndpoint;
            if (HtcsProxy.RegisterPortMap(LocalEndPoint, ipEndPoint) != 0)
            {
                throw new Exception(); // TODO: 適切な例外のスロー
            }
        }

        private void UnregisterPortMap()
        {
            try
            {
                if (HtcsProxy.UnregisterPortMap(LocalEndPoint) != 0)
                {
                    throw new Exception(); // TODO: 適切な例外のスロー
                }
            }
            catch (TargetManagerNotFoundException)
            {
                // Target Manager が切断している場合は、ポートマップの登録解除が失敗してもスルー。
            }
        }

        public void Start()
        {
            TcpListener.Start();
            if (HtcsProxy.Connected)
            {
                RegisterPortMap();
            }
            HtcsProxy.OnTargetManagerConnect += RegisterPortMap;
        }

        public void Stop()
        {
            HtcsProxy.OnTargetManagerConnect -= RegisterPortMap;
            if (HtcsProxy.Connected)
            {
                UnregisterPortMap();
            }
            TcpListener.Stop();
        }

        public HtcsEndPoint LocalEndPoint { get; private set; }
        private TcpListener TcpListener;
    }
}
