﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace Nintendo.HtcTools
{
    public sealed class HtclowChannelStream : Stream
    {
        private HtclowChannel htclowChannel;

        internal HtclowChannelStream(HtclowChannel htclowChannel)
        {
            this.htclowChannel = htclowChannel;

            htclowChannel.Connect();
        }

        public override int Read(byte[] buffer, int offset, int count)
        {
            return htclowChannel.Receive(buffer, offset, count);
        }

        public override void Write(byte[] buffer, int offset, int count)
        {
            htclowChannel.Send(buffer, offset, count);
        }

        public override bool CanRead
        {
            get
            {
                return true;
            }
        }

        public override bool CanSeek
        {
            get
            {
                return false;
            }
        }

        public override bool CanWrite
        {
            get
            {
                return true;
            }
        }

        public override long Length
        {
            get
            {
                throw new NotSupportedException();
            }
        }

        public override long Position
        {
            get
            {
                throw new NotSupportedException();
            }

            set
            {
                throw new NotSupportedException();
            }
        }

        public override void Flush()
        {
        }

        public override long Seek(long offset, SeekOrigin origin)
        {
            throw new NotSupportedException();
        }

        public override void SetLength(long value)
        {
            throw new NotSupportedException();
        }

        #region Dispose
        private bool disposed = false;

        protected override void Dispose(bool disposing)
        {
            if (disposed)
            {
                return;
            }

            if (disposing)
            {
                htclowChannel.Shutdown();
                htclowChannel.Dispose();
            }

            base.Dispose(disposing);

            disposed = true;
        }
        #endregion
    }
}
