﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fsa/fs_IDirectory.h>
#include <nn/fs/fsa/fs_IFile.h>
#include <nn/fssystem/fs_HostFileSystem.h>

namespace Nintendo { namespace HtcTools { namespace HtcfsNativeLibrary {

using namespace System;

public ref class File
{
public:
    File(nn::fs::fsa::IFile* pImpl)
        : m_pImpl(pImpl)
    {
        GC::KeepAlive(this);
    }

    ~File()
    {
        this->!File();
    }

    !File()
    {
        delete m_pImpl;
    }

    int32_t Read([Runtime::InteropServices::OutAttribute] int64_t %  outValue, int64_t offset, array<Byte>^ buffer, int64_t size);
    int32_t Write(int64_t offset, array<Byte>^ buffer, int64_t size, int32_t option);
    int32_t Flush();
    int32_t SetSize(int64_t size);
    int32_t GetSize([Runtime::InteropServices::OutAttribute] int64_t % outValue);

private:
    nn::fs::fsa::IFile* m_pImpl;
};

public ref class Directory
{
public:
    Directory(nn::fs::fsa::IDirectory* pImpl)
        : m_pImpl(pImpl)
    {
        GC::KeepAlive(this);
    }

    ~Directory()
    {
        this->!Directory();
    }

    !Directory()
    {
        delete m_pImpl;
    }

    static int32_t GetDirectoryEntrySize();

    int32_t Read([Runtime::InteropServices::OutAttribute] int64_t % outValue, array<Byte>^ buffer, int64_t bufferSize);
    int32_t GetEntryCount([Runtime::InteropServices::OutAttribute] int64_t % outValue);

private:
    nn::fs::fsa::IDirectory* m_pImpl;
};

public ref class FileSystem
{
public:
    FileSystem()
    {
        m_pImpl = new nn::fssystem::HostFileSystem();
    }

    ~FileSystem()
    {
        this->!FileSystem();
    }

    !FileSystem()
    {
        delete m_pImpl;
    }

    int32_t DoCreateFile(array<Byte>^ path, int64_t size);
    int32_t DoDeleteFile(array<Byte>^ path);
    int32_t DoCreateDirectory(array<Byte>^ path);
    int32_t DoDeleteDirectory(array<Byte>^ path);
    int32_t DoDeleteDirectoryRecursively(array<Byte>^ path);
    int32_t DoCleanDirectoryRecursively(array<Byte>^ path);
    int32_t DoRenameFile(array<Byte>^ currentPath, array<Byte>^ newPath);
    int32_t DoRenameDirectory(array<Byte>^ currentPath, array<Byte>^ newPath);
    int32_t DoGetEntryType([Runtime::InteropServices::OutAttribute] int32_t % directoryEntryType, array<Byte>^ path);
    int32_t DoOpenFile([Runtime::InteropServices::OutAttribute] File^ % file, array<Byte>^ path, int32_t mode);
    int32_t DoOpenDirectory([Runtime::InteropServices::OutAttribute] Directory^ % directory, array<Byte>^ path, int32_t mode);
    int32_t DoGetFileTimeStampRaw(
        [Runtime::InteropServices::OutAttribute] int64_t % createTime,
        [Runtime::InteropServices::OutAttribute] int64_t % modifyTime,
        [Runtime::InteropServices::OutAttribute] int64_t % accessTime,
        array<Byte>^ path);
    int32_t DoCommit();

private:
    nn::fssystem::HostFileSystem* m_pImpl;
};

}}}
