﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.HtcTools.HtcTmProxy
{
    internal class TmPacketHeader
    {
        private const int HeaderSize = 32;

        private const int ServiceIdOffset = 0;
        private const int TaskIdOffset = 4;
        private const int TaskTypeOffset = 8;
        private const int InitiateOffset = 10;
        private const int VersionOffset = 11;
        private const int DataLengthOffset = 12;

        public byte[] Buffer { get; } = new byte[HeaderSize];

        public int GetDataLength()
        {
            var span = new Span<byte>(Buffer);
            return span.Slice(DataLengthOffset).NonPortableCast<byte, int>()[0];
        }

        public override string ToString()
        {
            var span = new Span<byte>(Buffer);

            var serviceId = span.Slice(ServiceIdOffset).NonPortableCast<byte, int>()[0];
            var taskId = span.Slice(TaskIdOffset).NonPortableCast<byte, int>()[0];
            var taskType = span.Slice(TaskTypeOffset).NonPortableCast<byte, short>()[0];
            var initiate = span[InitiateOffset];
            var version = span[VersionOffset];
            var dataLength = span.Slice(DataLengthOffset).NonPortableCast<byte, int>()[0];

            return $"serviceId:{serviceId}, taskId:{taskId}, taskType:{taskType}, initiate:{initiate}, version:{version}, dataLength:{dataLength}";
        }
    }
}
