﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.FsAccessLogAnalysis
{
    public class AccessInfo : IComparable<AccessInfo>
    {
        public AccessInfo(ulong offset, ulong size, int count)
        {
            Offset = offset;
            Size = size;
            Count = count;
        }
        public AccessInfo(ulong offset, ulong size, int count, bool isGroupAccess)
        {
            Offset = offset;
            Size = size;
            Count = count;
            IsGroupAccess = isGroupAccess;
        }

        public ulong Offset { get; set; }
        public ulong Size { get; set; }
        public int Count { get; set; }
        public bool IsGroupAccess { get; set; }

        public ulong End
        {
            get { return Offset + Size; }
            set { Size = value - Offset; }
        }
        public ulong Begin
        {
            get { return Offset; }
            set
            {
                Size = End - value;
                Offset = value;
            }
        }

        public bool IsIntersect(AccessInfo accessInfo)
        {
            if (Offset >= accessInfo.End)
            {
                return false;
            }
            if (accessInfo.Offset >= End)
            {
                return false;
            }
            return true;
        }

        public int CompareTo(AccessInfo other)
        {
            if (Offset == other.Offset)
            {
                return Size.CompareTo(other.Size);
            }
            return Offset.CompareTo(other.Offset);
        }
    }

    internal class FsCache
    {
    }
}
