﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

namespace nn { namespace creport {

struct CrashReportHeader
{
    nn::Bit32 signature;
    nn::Bit32 version;
};

struct CrashReportRawDataV1
{
    nn::Bit64         exceptionCode;
    nn::Bit64         exceptionAddress;
    nn::Bit64         codeSpecificData;
    nn::Bit64         threadId;
    nn::Bit64         reg[29];
    nn::Bit64         fp;
    nn::Bit64         lr;
    nn::Bit64         sp;
    nn::Bit64         pc;
    nn::Bit64         pstate;
    nn::Bit64         stackTrace[32];
};

struct CrashReportRawDataV2
{
    nn::Bit64         exceptionCode;
    nn::Bit64         exceptionAddress;
    nn::Bit64         codeSpecificData;
    nn::Bit64         threadId;
    nn::Bit64         reg[29];
    nn::Bit64         fp;
    nn::Bit64         lr;
    nn::Bit64         sp;
    nn::Bit64         pc;
    nn::Bit64         pstate;
    nn::Bit64         variadic[160];
};

struct CrashReportRawDataV3
{
public:
    void Reset()
    {
        m_Index = 0;
    }

    void Read(void* pOutBuffer, size_t size)
    {
        memcpy(pOutBuffer, m_Data + m_Index, size);

        m_Index += size;
    }

private:
    nn::Bit8 m_Data[4096];
    size_t   m_Index;
};

struct CrashReportRaw
{
    CrashReportHeader header;
    union {
        CrashReportRawDataV1 dataV1;
        CrashReportRawDataV2 dataV2;
        CrashReportRawDataV3 dataV3;
    } data;
};

}} // nn::creport
