﻿using System.Windows;
using System.Windows.Controls;

namespace Nintendo.Authoring.AuthoringEditor.NspEntriesWindow
{
    public class FileEntryDetailPanelSelector : DataTemplateSelector
    {
        public override DataTemplate SelectTemplate(object item, DependencyObject container)
        {
            if (item == null)
                return null;

            try
            {
                var type = ((FileEntry) item).Type;

                return ((FrameworkElement) container).FindResource(type) as DataTemplate;
            }
            catch (ResourceReferenceKeyNotFoundException)
            {
                return null;
            }
        }
    }
}
