﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Linq;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media.Animation;
using BezelEditor.Foundation.Extentions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.SubPanel
{
    /// <summary>
    /// WorkingPanel.xaml の相互作用ロジック
    /// </summary>
    public partial class WorkingPanel
    {
        #region IsVisibled

        public bool IsVisibled
        {
            get { return (bool) GetValue(IsVisibledProperty); }
            set { SetValue(IsVisibledProperty, value); }
        }

        public static readonly DependencyProperty IsVisibledProperty =
            DependencyProperty.Register(
                nameof(IsVisibled),
                typeof(bool),
                typeof(WorkingPanel),
                new FrameworkPropertyMetadata
                {
                    PropertyChangedCallback = OnIsVisibledChanged,
                    DefaultValue = default(bool),
                    BindsTwoWayByDefault = true
                }
            );

        private static void OnIsVisibledChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            Debug.Assert(d is WorkingPanel);
            var self = (WorkingPanel) d;

            self.StartAnim();
        }

        #endregion

        public WorkingPanel()
        {
            InitializeComponent();
        }

        private Storyboard _latestAnim;


        private UIElement _ParentControl;
        private UIElement ParentControl
        {
            get
            {
                if (_ParentControl == null)
                    _ParentControl =
                        Application.Current.MainWindow.Descendants()
                            .OfType<Control>()
                            .FirstOrDefault(x => x.Name == "ModePanelContentControl");

                return _ParentControl;
            }
        }

        public void Show()
        {
            IsHitTestVisible = true;
            var anim = TryFindResource("ShowBuildPanelAnim") as Storyboard;
            anim?.Begin(this, true);

            _latestAnim = anim;

            if (ParentControl == null)
                return;

            ParentControl.PreviewKeyDown += ParentOnPreviewKeyDown;
        }

        private void ParentOnPreviewKeyDown(object sender, KeyEventArgs keyEventArgs)
        {
            if (Opacity != 0)
                keyEventArgs.Handled = true;
        }

        public void Hide()
        {
            IsHitTestVisible = false;
            var anim = TryFindResource("HideBuildPanelAnim") as Storyboard;
            anim?.Begin(this, true);

            _latestAnim = anim;

            if (ParentControl == null)
                return;


            ParentControl.PreviewKeyDown -= ParentOnPreviewKeyDown;
        }

        private void StartAnim()
        {
            if (IsVisibled)
            {
                Opacity = 0;
                Visibility = Visibility.Visible;
                Show();
            }
            else
                Hide();
        }

        public void StopAnim()
        {
            _latestAnim.Stop();
        }

        private void Grid_DataContextChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            // 何度も切り替わるのは駄目
            Debug.Assert(e.OldValue == null);

            var dataContext = (WorkingPanelVm) DataContext;

            dataContext.IsFadeoutWorkingPanel
                .Subscribe(i =>
                {
                    if (i)
                        Hide();
                    else
                    {
                        StopAnim();
                        Visibility = Visibility.Hidden;
                    }
                })
                .AddTo(dataContext.CompositeDisposable);
        }
    }
}
