﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.StartupPanel
{
    public class MruList : Control
    {
        #region Title

        public string Title
        {
            get { return (string) GetValue(TitleProperty); }
            set { SetValue(TitleProperty, value); }
        }

        public static readonly DependencyProperty TitleProperty =
            DependencyProperty.Register(
                nameof(Title),
                typeof(string),
                typeof(MruList),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(string),
                    BindsTwoWayByDefault = false
                }
            );

        #endregion

        #region OpenAnotherCaption

        public string OpenAnotherCaption
        {
            get { return (string) GetValue(OpenAnotherCaptionProperty); }
            set { SetValue(OpenAnotherCaptionProperty, value); }
        }

        public static readonly DependencyProperty OpenAnotherCaptionProperty =
            DependencyProperty.Register(
                nameof(OpenAnotherCaption),
                typeof(string),
                typeof(MruList),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(string),
                    BindsTwoWayByDefault = false
                }
            );

        #endregion

        #region ItemsSource

        public IEnumerable ItemsSource
        {
            get { return (IEnumerable) GetValue(ItemsSourceProperty); }
            set { SetValue(ItemsSourceProperty, value); }
        }

        public static readonly DependencyProperty ItemsSourceProperty =
            DependencyProperty.Register(
                nameof(ItemsSource),
                typeof(IEnumerable),
                typeof(MruList),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(IEnumerable),
                    BindsTwoWayByDefault = false
                }
            );

        #endregion

        #region OpenAnotherCommand

        public ICommand OpenAnotherCommand
        {
            get { return (ICommand) GetValue(OpenAnotherCommandProperty); }
            set { SetValue(OpenAnotherCommandProperty, value); }
        }

        public static readonly DependencyProperty OpenAnotherCommandProperty =
            DependencyProperty.Register(
                nameof(OpenAnotherCommand),
                typeof(ICommand),
                typeof(MruList),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(ICommand),
                    BindsTwoWayByDefault = false
                }
            );

        #endregion

        #region ItemTemplate

        public DataTemplate ItemTemplate
        {
            get { return (DataTemplate) GetValue(ItemTemplateProperty); }
            set { SetValue(ItemTemplateProperty, value); }
        }

        public static readonly DependencyProperty ItemTemplateProperty =
            DependencyProperty.Register(
                nameof(ItemTemplate),
                typeof(DataTemplate),
                typeof(MruList),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(DataTemplate),
                    BindsTwoWayByDefault = false
                }
            );

        #endregion
    }
}
