﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reactive.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;
using SimpleInjector;
using static Nintendo.Authoring.AuthoringEditor.Properties.Resources;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class TitlePageVm : PageVmBase
    {
        public TitleParamVm TitleParam { get; }

        public ReadOnlyReactiveProperty<bool> CanAddOrRemoveTitle { get; }

        public TitlePageVm(Container diContainer, Project project, AppProfile profile)
            : base(nameof(Properties.Resources.Title))
        {
            var isReadOnlyRp = project.Meta.ToReactivePropertyAsSynchronized(x => x.IsReadOnly).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            CanAddOrRemoveTitle = isReadOnlyRp
                .Select(x => x == false && (
                    // タイプが AppMeta または Project
                    profile.AppMode == AppModeType.ApplicationMeta ||
                    profile.AppMode == AppModeType.Project ||
                    // AppNsp の場合は Capability で編集が許可されている
                    (profile.AppMode == AppModeType.ApplicationNsp && project.AppCapability.IsSupportNspTitleAddOrRemove)))
                .ToReadOnlyReactiveProperty()
                .AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            TitleParam = new TitleParamVm(
                diContainer,
                nameof(Title_Caption),
                nameof(Title_Comment),
                project.Meta,
                project.Meta.Application.Titles,
                isReadOnlyRp,
                CanAddOrRemoveTitle
            ).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            Params = new ParamVm[]
            {
                TitleParam
            };

            /////////////////////////////////////////////////////////
            project.Meta.Application.ObserveProperty(x => x.IsErrorTitles)
                .Where(_ => isReadOnlyRp.Value == false)
                .Subscribe(i => HasErrors.Value = i)
                .AddTo(CompositeDisposable);
        }
    }
}
