﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Reactive.Bindings.Extensions;
using SimpleInjector;
using static Nintendo.Authoring.AuthoringEditor.Properties.Resources;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class TemporaryDataAreaPageVm : PageVmBase
    {
        public CapacityParamVm TemporaryStorageSize { get; }
        public CapacityParamVm CacheStorageSize { get; }
        public CapacityParamVm CacheStorageJournalSize { get; }

        public TemporaryDataAreaPageVm(Container diContainer, Project project)
            : base(nameof(TemporaryDataArea))
        {
            var isReadOnlyRp = project.Meta.ToReactivePropertyAsSynchronized(x => x.IsReadOnly).AddTo(CompositeDisposable);

            var app = project.Meta.Application;
            var validations = diContainer.GetInstance<PageValidations>();

            /////////////////////////////////////////////////////////
            TemporaryStorageSize = CreateCapacityParamVm(
                nameof(TemporaryStorageSize_Caption),
                nameof(TemporaryStorageSize_Comment),
                app.ToReactivePropertyAsSynchronized(x => x.TemporaryStorageSize),
                nameof(IsUse),
                app.ToReactivePropertyAsSynchronized(x => x.IsUseTemporaryStorageSize),
                s => validations.TemporaryStorageSize(app.IsUseTemporaryStorageSize, s));

            TemporaryStorageSize.IsReadOnly = isReadOnlyRp;

            /////////////////////////////////////////////////////////
            var summary = new CacheStorageSummaryParamVm(
                nameof(CacheStorage_TotalSaveData_Caption),
                nameof(CacheStorage_TotalSaveData_Comment),
                project.Meta
            ).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            CacheStorageSize = CreateCapacityParamVm(
                nameof(CacheStorageSize_Caption),
                nameof(CacheStorageSize_Comment),
                app.ToReactivePropertyAsSynchronized(x => x.CacheStorageSize),
                nameof(IsUse),
                app.ToReactivePropertyAsSynchronized(x => x.IsUseCacheStorageSize),
                s => validations.CacheStorageSize(app.IsUseCacheStorageSize, s));

            CacheStorageSize.IsReadOnly = isReadOnlyRp;

            /////////////////////////////////////////////////////////
            CacheStorageJournalSize = CreateCapacityParamVm(
                nameof(CacheStorageJournalSize_Caption),
                nameof(CacheStorageJournalSize_Comment),
                app.ToReactivePropertyAsSynchronized(x => x.CacheStorageJournalSize),
                nameof(IsUse),
                app.ToReactivePropertyAsSynchronized(x => x.IsUseCacheStorageJournalSize),
                s => validations.CacheStorageSize(app.IsUseCacheStorageJournalSize, s));

            CacheStorageJournalSize.IsReadOnly = isReadOnlyRp;

            /////////////////////////////////////////////////////////
            Params = new ParamVm[]
            {
                TemporaryStorageSize,
                summary,
                CacheStorageSize,
                CacheStorageJournalSize
            };
        }
    }
}
