﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Reactive.Linq;
using System.Windows.Media;
using BezelEditor.Mvvm;
using Livet.Messaging.Windows;
using Nintendo.Authoring.AuthoringEditor.Convertes;
using Nintendo.Authoring.AuthoringEditor.Core;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Controls
{
    public class IconActualSizePreviewWindowVm : ViewModelBase
    {
        public double IconWidth { get; }
        public double IconHeight { get; }

        public ReactiveCommand CloseCommand { get; }

        public ReadOnlyReactiveProperty<string> Caption { get; }

        public ReadOnlyReactiveProperty<Brush> IconBrush { get; }

        private EnumToCaptionConverter EnumConverter { get; } = new EnumToCaptionConverter();

        public IconActualSizePreviewWindowVm(
            string iconType,
            Title model,
            ReadOnlyReactiveProperty<Brush> iconBrush,
            double width,
            double height)
        {
            Debug.Assert(model != null);

            // ViewModel の破棄と同時に View を閉じる
            CompositeDisposable.Add(() => CloseCommand?.Execute());

            IconWidth = width;
            IconHeight = height;

            CloseCommand = new ReactiveCommand().AddTo(CompositeDisposable);
            CloseCommand
                .Subscribe(_ => Messenger.Raise(new WindowActionMessage(WindowAction.Close, "WindowAction")))
                .AddTo(CompositeDisposable);

            IconBrush = iconBrush.AddTo(CompositeDisposable);

            Caption = Observable
                .Merge(model.ObserveProperty(x => x.Language).ToUnit())
                .Select(_ => $"{EnumConverter.Convert(model.Language, null, null, null)} - {iconType}")
                .ToReadOnlyReactiveProperty()
                .AddTo(CompositeDisposable);
        }
    }
}
