﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Globalization;
using BezelEditor.Mvvm;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Properties;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor
{
    public class CultureService : DisposableModelBase
    {
        public static CultureService Instance { get; } = new CultureService();

        public Resources Resources { get; } = new Resources();

        #region CultureName

        private string _CultureName = string.Empty;

        public string CultureName
        {
            get { return _CultureName; }
            set
            {
                if (SetProperty(ref _CultureName, value) == false)
                    return;

                Resources.Culture = CultureInfo.GetCultureInfo(value);

                // ReSharper disable once ExplicitCallerInfoArgument
                RaisePropertyChanged(nameof(Resources));
            }
        }

        #endregion

        public void Initialize(Config config)
        {
            config.ObserveProperty(x => x.Culture)
                .Subscribe(c => CultureName = c)
                .AddTo(CompositeDisposable);
        }

        private CultureService()
        {
        }
    }
}
