﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.IO;
using System.Text;
using Nintendo.Authoring.FileSystemMetaLibrary;

namespace Nintendo.Authoring.AuthoringEditor.Helper
{
    public class ExtractFileInfo
    {
        public IFileSystemArchiveReader Reader { get; set; }
        public long FileSize { get; set; }
        public string Name { get; set; }
        public string FullName { get; set; }
        public string OutputPath { get; set; }

        public string WriteFile(string outputDirectory)
        {
            var outputPath = Path.Combine(outputDirectory, OutputPath);
            FsUtil.WriteFile(outputPath, Reader, Name, FileSize);
            return outputPath;
        }

        public string ReadAllText(Encoding encoding)
        {
            using (var writer = new MemoryStream())
            {
                FsUtil.WriteFile(writer, Reader, Name, FileSize);
                writer.Flush();
                writer.Position = 0;
                return new StreamReader(writer, encoding).ReadToEnd();
            }
        }
    }
}
