﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

namespace Nintendo.Authoring.AuthoringEditor.Foundation
{
    public class NspHandleErrorException : SystemException
    {
        private readonly NspHandleResultType _ResultType;

        public NspHandleResult Result => _ResultType.Result;

        public IReadOnlyCollection<string> ErrorMessages => _ResultType.ErrorMessages;

        public NspHandleErrorException(NspHandleResult result) : base(result.ToString())
        {
            _ResultType = new NspHandleResultType() {Result = result, ErrorMessages = new string[] {}};
        }

        public NspHandleErrorException(NspHandleResultType resultType) : base(resultType.Result.ToString())
        {
            _ResultType = resultType;
        }

        public NspHandleErrorException(NspHandleResultType resultType, Exception innerException)
            : base(resultType.Result.ToString(), innerException)
        {
            _ResultType = resultType;
        }
    }
}
