﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Runtime.InteropServices;

namespace Nintendo.Authoring.AuthoringEditor.Foundation
{
    public static class ArrayHelper
    {
        public static bool IsEqual(byte[] b1, byte[] b2)
        {
            if (b1 == null && b2 == null)
                return true;

            if ((b1 != null && b2 != null) == false)
                return false;

            if (b1.Length != b2.Length)
                return false;

            return memcmp(b1, b2, new IntPtr(b1.Length)) == IntPtr.Zero;
        }

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern IntPtr memcmp(byte[] b1, byte[] b2, IntPtr count);
    }
}
