﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using BezelEditor.Mvvm;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.Core
{
    public class SelectedTargetSalesRegion : ModelBase
    {
        private TargetSalesRegion _Region;

        public TargetSalesRegion Region
        {
            get { return _Region; }
            set { SetProperty(ref _Region, value); }
        }

        private bool _IsUse;

        public bool IsUse
        {
            get { return _IsUse; }
            set { SetProperty(ref _IsUse, value); }
        }
    }

    public class RatingData
    {
        public TargetSalesRegion TargetSalesRegion { get; set; }

        public string RatingOrganization { get; set; }

        public Dictionary<string, string> RegionNames { get; set; }
        public Dictionary<string, string[]> TargetCountryNames { get; set; }

        public RatingCategoryData[] Categories { get; set; }

        // Categories のデータから同一の AgeValue の年齢区分を集約したカテゴリの一覧
        public List<AggregatedRatingCategoryData> AgeAggregatedCategories { get; set; }
    }

    public class AggregatedRatingCategoryData
    {
        public string[] RatingCategories { get; set; }
        public int AgeValue { get; set; }

        // カルチャーごとのカテゴリ名称
        public Dictionary<string, List<string>> Names { get; set; }
    }

    public class RatingCategoryData
    {
        public string RatingCategory { get; set; }
        public int AgeValue { get; set; }

        // カルチャーごとのカテゴリ名称
        public Dictionary<string, string> Names { get; set; }
    }
}
