﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.AuthoringEditor.Foundation;

namespace Nintendo.Authoring.AuthoringEditor.Core
{
    public class ApplicationCapability
    {
        private Lazy<Version> _nxAddonVersion;

        private Lazy<bool> _isNXAddon1xOrLaterVersion;

        public Version NxAddonVersion => _nxAddonVersion.Value;

        public bool HasValidVersion => _nxAddonVersion.Value != new Version();

        public ApplicationCapability()
        {
            _nxAddonVersion = new Lazy<Version>(() => new Version(AuthoringToolWrapper.NxAddonVersion() ?? "0.0.0"));
            _isNXAddon1xOrLaterVersion = new Lazy<bool>(() => _nxAddonVersion.Value.Major >= 1);
        }

        public static ApplicationCapability CreateCustomCapability(Lazy<Version> version)
        {
            var capability = new ApplicationCapability();
            capability._nxAddonVersion = version;
            return capability;
        }

        // パッチの作成をサポートする
        public bool IsSupportMakingPatch => _isNXAddon1xOrLaterVersion.Value;

        // SaveDataOwnerIds 要素が利用可能
        public bool IsSupportSaveDataOwnerIds => _isNXAddon1xOrLaterVersion.Value;

        // SeedForPseudoDeviceId 要素が利用可能
        public bool IsSupportSeedForPseudoDeviceId => _isNXAddon1xOrLaterVersion.Value;

        // Nsp のタイトル情報編集をサポートする (nca のファイル add/remove サポートの有無)
        public bool IsSupportNspTitleAddOrRemove => _isNXAddon1xOrLaterVersion.Value;

        // Nsp の Icon 変換をサポートする (showicon サブコマンドサポートの有無)
        public bool IsSupportNspIconConvert => _isNXAddon1xOrLaterVersion.Value;

        // NintendoSdkMeta が利用可能 (>= NX Addon 3.0.0)
        public bool IsSupportNintendoSdkMetaRoot => _nxAddonVersion.Value >= new Version(3, 0, 0);

        // Core/SystemResourceSize が利用可能 (>= NX Addon 3.0.0)
        public bool IsSupportSystemResourceSize => _nxAddonVersion.Value >= new Version(3, 0, 0);

        // Bcat が利用可能 (NX Addon >= 3.0.0)
        public bool IsSupportBcat => _nxAddonVersion.Value >= new Version(3, 0, 0);

        // アプリケーションによるセーブデータの拡張が使用可能 (>= NX Addon 3.1.0)
        public bool IsSupportSaveDataSizeExtend => _nxAddonVersion.Value >= new Version(3, 1, 0);

        //アプリケーション用の揮発性／不揮発性領域が使用可能 (>= NX Addon 3.1.0)
        public bool IsSupportTempAndCacheStorage => _nxAddonVersion.Value >= new Version(3, 1, 0);

        // HDCP が利用可能 (NX Addon >= 3.2.0)
        public bool IsSupportHdcp => _nxAddonVersion.Value >= new Version(3, 2, 0);

        // UserAccoutnSaveDataOperation が利用可能 (>= NX Addon 3.2.0)
        public bool IsSupportUserAccoutnSaveDataOperation => _nxAddonVersion.Value >= new Version(3, 2, 0);

        // 中韓台の言語の編集が可能 (>= NX Addon 4.0.0)
        public bool IsSupportEditChineseAndKoreanLanguages => _nxAddonVersion.Value >= new Version(4, 0, 0);

        // AoC の DataPath 以外の全てのパス指定項目に環境変数を使用可能 (>= NX Addon 4.0.0)
        public bool IsSupportEnvironmentVariableToPath => _nxAddonVersion.Value >= new Version(4, 0, 0);

        // VideoCapture 要素が SDK ユーザー向けに公開され使用可能 (>= NX Addon 4.2.0 || (NX Addon 4.0.0 > && >= NX Addon 3.6.0))
        public bool IsSupportVideoCapture => _nxAddonVersion.Value >= new Version(4, 2, 0)
            || (new Version(4, 0, 0) > _nxAddonVersion.Value && _nxAddonVersion.Value >= new Version(3, 6, 0));

        // RuntimeAddOnContentInstall が使用可能 (>= NX Addon 4.2.0)
        public bool IsSupportRuntimeAddOnContentInstall => _nxAddonVersion.Value >= new Version(4, 2, 0);

        // CrashReport が編集可能 (>= NX Addon 3.6.0)
        public bool IsSupportCrashReport => _nxAddonVersion.Value >= new Version(3, 6, 0);

        // フィルタ記述ファイルの .nmeta への記載が可能 (>= NX Addon 4.2.0)
        public bool IsSupportFilterDescriptionFileInMeta => _nxAddonVersion.Value >= new Version(4, 2, 0);

        // プレイ情報の取得に関する設定が可能 (NX Addon 5.0.0 >=)
        public bool IsSupportPlayLogs => _nxAddonVersion.Value >= new Version(5, 0, 0);

        // パッチ間ファイル差分の表示をサポートする (NX Addon 5.0.0 >=)
        public bool IsSupportPatchDifference => _nxAddonVersion.Value >= new Version(5, 0, 0);

        // アプリケーション起動時のライセンス種別指定をサポートする (NX Addon 5.4.1 >=)
        // サポートであって一般公開ではない点に注意。該当の nmeta 項目がなければ編集用 UI は表示しない
        // 一般公開の際は、それ用のケイパビリティを別に用意する
        public bool IsSupportRequiredNetworkServiceLicenseOnLaunch => _nxAddonVersion.Value >= new Version(5, 4, 1);
    }
}
