﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Linq;

namespace SystemAudioMonitor
{
    public class LoudnessIndicator : IWaveProcessor
    {
        private LoudnessAccumulator _accumulator;

        // Loudness
        public float ShortTermLoudness { get; private set; } = float.NegativeInfinity;
        public float MomentaryLoudness { get; private set; } = float.NegativeInfinity;
        public float IntegratedLoudness { get; private set; } = float.NegativeInfinity;

        public LoudnessIndicator(WaveformFormat _format)
        {
            _accumulator = new LoudnessAccumulator();
            _accumulator.SetParameter(Loudness.Parameter48kHz);
        }

        public void AddSamples(byte[] buffer, int offset, int count)
        {
            var loudnessInfo = _accumulator.Accumulate(buffer, offset, count).LastOrDefault();
            if (loudnessInfo != null)
            {
                IntegratedLoudness = loudnessInfo.RelGatedLoudnessValue;
                MomentaryLoudness = loudnessInfo.MomentaryLoudnessValue;
                ShortTermLoudness = loudnessInfo.ShortTermLoudnessValue;
            }
        }

        public void OnCaptureStopped(Exception e)
        {
        }
    }
}
