﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using System.Windows;

namespace SpatialAudioEvaluationTool
{
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            Closing += OnClose;

            // 本来は Messanger パターンを使うべきだが、コストを考えて暫定的な対応を行う
            var viewModel = DataContext as MainWindowViewModel;
            viewModel.ConnectionError = OnConnectionError;
            viewModel.MonitoringError = OnMonitoringError;
        }
        private void OnConnectionError(object sender, Exception e)
        {
            Dispatcher.BeginInvoke(new Action(() =>
            {
                WindowEffect.FlashTaskbar();
                MessageBox.Show(this, e.Message, SpatialAudioEvaluationTool.Resources.MainWindowResources.ConnectionErrorCaption, MessageBoxButton.OK, MessageBoxImage.Warning, MessageBoxResult.OK);
                WindowEffect.UnflashTaskbar();
            }));
        }

        private void OnMonitoringError(object sender, Exception e)
        {
            Dispatcher.BeginInvoke(new Action(() =>
            {
                WindowEffect.FlashTaskbar();
                MessageBox.Show(this, e.Message, SpatialAudioEvaluationTool.Resources.MainWindowResources.MonitoringErrorCaption, MessageBoxButton.OK, MessageBoxImage.Warning, MessageBoxResult.OK);
                WindowEffect.UnflashTaskbar();
            }));
        }

        private void OnClose(object sender, CancelEventArgs e)
        {
            var viewModel = DataContext as MainWindowViewModel;
            if (viewModel != null)
            {
                viewModel.MonitoringError = null;
                viewModel.ConnectionError = null;
                viewModel.Dispose();
            }
        }
    }
}
