﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Audio.Windows.CoreAudio.Interface;
using System;
using System.Runtime.InteropServices;

namespace Nintendo.Audio.Windows.CoreAudio
{
    public class SpatialAudioObjectRenderStream : IDisposable
    {
        private ISpatialAudioObjectRenderStream _target;

        public uint AvailableDynamicObjectCount
        {
            get
            {
                Marshal.ThrowExceptionForHR(_target.GetAvailableDynamicObjectCount(out var count));
                return count;
            }
        }

        public SpatialAudioObjectRenderStream(object target)
        {
            _target = target as ISpatialAudioObjectRenderStream;
        }

        public SpatialAudioObjectRenderStream(ISpatialAudioObjectRenderStream target)
        {
            _target = target;
        }

        public void Start()
        {
            Marshal.ThrowExceptionForHR(_target.Start());
        }

        public void Stop()
        {
            Marshal.ThrowExceptionForHR(_target.Stop());
        }

        public void Reset()
        {
            Marshal.ThrowExceptionForHR(_target.Reset());
        }

        public ISpatialAudioObject ActivateSpatialAudioObject(AudioObjectType type)
        {
            if (_target == null)
            {
                return null;
            }
            Marshal.ThrowExceptionForHR(_target.ActivateSpatialAudioObject(type, out var result));
            return result;
        }

        public void BeginUpdatingAudioObjects(out uint availableDynamicObjectCount, out uint frameCountPerBuffer)
        {
            Marshal.ThrowExceptionForHR(_target.BeginUpdatingAudioObjects(out var objectCount, out var sampleCount));
            availableDynamicObjectCount = objectCount;
            frameCountPerBuffer = sampleCount;
        }

        public void EndUpdatingAudioObjects()
        {
            Marshal.ThrowExceptionForHR(_target.EndUpdatingAudioObjects());
        }

        public void Dispose()
        {
            if (_target != null)
            {
                Marshal.ReleaseComObject(_target);
                _target = null;
            }
        }
    }
}
