﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Audio.Windows.CoreAudio.Interface;
using System;
using System.Runtime.InteropServices;

namespace Nintendo.Audio.Windows.CoreAudio
{
    public class MMDevice : IDisposable
    {
        private IMMDevice _target;

        public MMDevice(IMMDevice target)
        {
            _target = target;
        }

        public object Activate(Guid interfaceId)
        {
            return Activate(interfaceId, ClsCtx.ALL, IntPtr.Zero);
        }

        public object Activate(Guid interfaceId, IntPtr activationParams)
        {
            return Activate(interfaceId, ClsCtx.ALL, activationParams);
        }

        public object Activate(Guid interfaceID, ClsCtx classContext, IntPtr activationParams)
        {
            Marshal.ThrowExceptionForHR(_target.Activate(interfaceID, classContext, activationParams, out var result));
            return result;
        }

        public void Dispose()
        {
            if (_target != null)
            {
                Marshal.ReleaseComObject(_target);
                _target = null;
            }
        }
    }
}
