﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Runtime.InteropServices;

namespace Nintendo.Audio.Windows.CoreAudio.Interface
{
    [ComImport]
    [Guid(CoreAudioGuid.IAudioRenderClientIdText)]
    [InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
    public interface IAudioRenderClient
    {
        [PreserveSig]
        int GetBuffer(UInt32 numFramesRequested, out IntPtr buffer);

        [PreserveSig]
        int ReleaseBuffer(UInt32 numFramesWritten, UInt32 flags);
    }
}
