﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Types.h"
#include "chunkname.h"


/*--------------------------------------------------------------------------*
    RIFF chunk names
 *--------------------------------------------------------------------------*/
#define CHUNK_RIFF  chunk_name('R','I','F','F')
#define CHUNK_WAVE  chunk_name('W','A','V','E')


/*--------------------------------------------------------------------------*
    CHUNK structs
 *--------------------------------------------------------------------------*/
typedef struct
{
    char       chunkId[4];
    u32        chunkSize;

    u16        waveFormatType;
    u16        channel;
    u32        samplesPerSec;
    u32        bytesPerSec;
    u16        blockSize;
    u16        bitsPerSample;

} FMTCHUNK;

typedef struct
{
    char       chunkId[4];
    u32        chunkSize;

} DATACHUNK;

typedef struct
{
    char       chunkId[4];
    u32        chunkSize;

    char       formType[4];
    FMTCHUNK   fmt;
    DATACHUNK  data;

} WAVECHUNK;

typedef struct
{
    char       chunkId[4];
    u32        chunkSize;

    u32        manufacturer;
    u32        product;
    u32        samplePeriod;
    u32        midiUnityNote;
    u32        midiPitchFraction;
    u32        smpteFormat;
    u32        smpteOffset;
    u32        sampleLoops;
    u32        samplerData;

} SMPLCHUNK;

typedef struct
{
    u32        id;
    u32        type;
    u32        start;
    u32        end;
    u32        fraction;
    u32        playCount;

} SMPLLOOP;

typedef struct
{
    u32        start;
    u32        end;

} LOOPINFO;


/*--------------------------------------------------------------------------*
    Function prototypes
 *--------------------------------------------------------------------------*/
void wavCreateHeader     ( WAVECHUNK *wc,
                           int       channels,
                           int       samples,
                           int       bitsPerSample,
                           int       sampleRate,
                           int       loopEnd );

void wavWriteHeader      ( WAVECHUNK *wc,
                           FILE      *outfile );

void wavCreateSmplChunk  ( WAVECHUNK *wc,
                           SMPLCHUNK *sc,
                           SMPLLOOP  *sl,
                           u32       loopStart,
                           u32       loopEnd );

void wavWriteSmplChunk   ( SMPLCHUNK *sc,
                           SMPLLOOP  *sl,
                           FILE      *outfile );

int  wavReadHeader       ( WAVECHUNK *wc,
                           LOOPINFO  *li,
                           FILE      *infile );

u32  wavGetSamples       ( WAVECHUNK *wc );
u32  wavGetChannels      ( WAVECHUNK *wc );
u32  wavGetBitsPerSample ( WAVECHUNK *wc );
u32  wavGetSampleRate    ( WAVECHUNK *wc );
